# Suri Oculus — AI Module for Network Traffic Analysis

**Suri Oculus AI Module** is a standalone AI-based analyzer for Suricata network traffic events (Flow, HTTP, DNS, TLS), powered by machine learning (Isolation Forest models).

It provides a REST API and a full-featured web interface for traffic anomaly detection, visualization, and exploration.

---

## 🧠 Key Features

- Anomaly detection for Suricata events (flow, http, dns, tls)
- Meta-behavioral analysis across all traffic types
- Multi-anomaly detection (simultaneous anomalies in different streams)
- Time-based visualizations (timeline, hourly/daily comparison)
- Interactive web interface (HTML + JS)
- REST API built with FastAPI
- JSON data input (from Redis or manually)
- Export to CSV / JSON
- C++ feature extraction module (binary only, source code excluded)

---

## 📁 Project Structure

suri-oculus-ai/
├── ai_rest_api.py # REST API server
├── *.py # Python modules: flow, http, dns, tls, meta
├── *.pkl, *_features.txt # Pre-trained models and feature lists
├── cpplib/libsuri_features.so # C++ library (no source code included)
├── web/ # Web UI (HTML, JS, CSS)
├── run.sh # Launch script
├── install.sh # Installer script

---

## ⚙️ Requirements

- Python 3.9+
- Redis (running on `localhost:6379`)
- Python packages listed in `requirements.txt`:
  - `fastapi`
  - `uvicorn`
  - `pandas`
  - `joblib`
  - `scikit-learn`
  - `plotly`
  - `numpy`

---
---

## 🔗 External Requirements

To function properly, the AI module requires:

- A running instance of the **Suricata IDS**
- The background service **daemonmove** installed and running

### What is daemonmove?

`daemonmove` is a background daemon developed for Suri Oculus. It performs:

- real-time ingestion of Suricata logs via `unix-socket` or `eve.json`,
- transformation of events into structured JSON format,
- delivery of data into Redis for AI-based analysis.

Installation and configuration guide:  
👉 https://suri-oculus.com/docs/log-parser-daemonmove-service/

## 🚀 Installation and Launch

```bash
# 1. Unpack the archive
tar -xzf suri-oculus-ai.tar.gz
cd suri-oculus-ai

# 2. Run installation
./install.sh

Remark Before Launching the Module

Before using the run.sh script, the following manual adjustments must be made:

In the config.js file (line with backendUrl), replace http://127.0.0.1:5000 with the actual IP address of the server where the backend module is running. Otherwise, the frontend will not be able to connect to the API.

In the run.sh file (line starting the HTTP server), specify the real path to the web directory where the frontend files are located:

# Start simple HTTP-server for frontend
python3 -m http.server 8000 --directory /path_to_web_folder


Otherwise, the web server will not find the frontend and the interface will not be available.
# 3. Start the module
./run.sh
Once started:

API: http://localhost:5000

Web interface: http://localhost:8000

🔍 Usage
The module can be used as:

an offline analysis tool (manual JSON input)

an addition to a live Suricata setup (via Redis)

an AI-powered showcase for anomaly detection in network traffic

🛠 CLI Usage
Each module can also be run via CLI:

bash
Копировать
Редактировать
python3 main.py dns --analyze
python3 main.py flow --retrain
python3 main.py meta --train --windows 200 --window_size 60
📬 Contact and Support
Project: https://suri-oculus.com
Telegram (RU): https://t.me/suri_oculus

© 2025, Suri Oculus Project. All rights reserved.
---