# main.py

import argparse
from dns_ai_module import main as dns_main
from http_ai_module import main as http_main
from tls_ai_module import main as tls_main
from flow_ai_module import main as flow_main
from integrated_model import main as meta_main

def main():
    parser = argparse.ArgumentParser(description="Suri-Oculus AI CLI")
    subparsers = parser.add_subparsers(dest='module', help='Select module')

    # DNS
    dns_parser = subparsers.add_parser("dns", help="Analysis for DNS")
    dns_parser.add_argument('--retrain', action='store_true')
    dns_parser.add_argument('--analyze', action='store_true')
    dns_parser.add_argument('--file', type=str)
    dns_parser.add_argument('--live', action='store_true')

    # HTTP
    http_parser = subparsers.add_parser("http", help="Analysis for HTTP")
    http_parser.add_argument('--retrain', action='store_true')
    http_parser.add_argument('--analyze', action='store_true')
    http_parser.add_argument('--file', type=str)
    http_parser.add_argument('--live', action='store_true')

    # TLS
    tls_parser = subparsers.add_parser("tls", help="Analysis for TLS")
    tls_parser.add_argument('--retrain', action='store_true')
    tls_parser.add_argument('--analyze', action='store_true')
    tls_parser.add_argument('--file', type=str)
    tls_parser.add_argument('--live', action='store_true')

    # FLOW
    flow_parser = subparsers.add_parser("flow", help="Analysis for Flow")
    flow_parser.add_argument('--retrain', action='store_true')
    flow_parser.add_argument('--analyze', action='store_true')
    flow_parser.add_argument('--file', type=str)
    flow_parser.add_argument('--live', action='store_true')

    # META
    meta_parser = subparsers.add_parser("meta", help="Meta-analysis")
    meta_parser.add_argument('--train', action='store_true')
    meta_parser.add_argument('--check', action='store_true')
    meta_parser.add_argument('--windows', type=int, default=200)
    meta_parser.add_argument('--window_size', type=int, default=60)
    meta_parser.add_argument('--shift', type=int, default=0)

    args = parser.parse_args()

    if args.module == "dns":
        dns_main(args)
    elif args.module == "http":
        http_main(args)
    elif args.module == "tls":
        tls_main(args)
    elif args.module == "flow":
        flow_main(args)
    elif args.module == "meta":
        meta_main(args)
    else:
        parser.print_help()

if __name__ == "__main__":
    main()
