# User Guide — Suri Oculus AI Module

This guide explains how to use the web interface and API for the Suri Oculus AI-based anomaly detection module for Suricata traffic.

---

## 🔗 Accessing the Module

After running `./run.sh`:

- Web UI: [http://localhost:8000](http://localhost:8000)
- REST API: [http://localhost:5000](http://localhost:5000)

---

## 🖥️ Web Interface Overview

The interface includes six tabs, each targeting specific traffic types:

### 1. **Flow Events**
- Detects anomalies based on network flow statistics (`flow`)
- Timeline graph of anomalies
- Compare anomalies: Today vs Yesterday
- Manual JSON input and analysis

### 2. **TLS Events**
- Analyzes JA3, JA3S, SNI and TLS version
- Similar features as Flow tab

### 3. **DNS Events**
- Inspects DNS queries and responses
- Includes anomaly detection and visual comparisons

### 4. **HTTP Events**
- Analyzes URL length, user-agent, HTTP status codes, sizes
- Uses both `http` and `flow` fields

### 5. **Meta Analysis**
- Aggregated behavioral analysis across all streams
- Meta-model identifies abnormal global network behavior

### 6. **Multi-Anomaly Detection**
- Detects simultaneous anomalies across ≥2 traffic types
- Graph view and anomaly list
- Mark anomalies as escalated
- Optional email alerts (via SMTP config)

---

## 📝 Manual JSON Analysis

Each tab provides a field for manual analysis:

- Paste a JSON array of events (e.g. `[{"flow": {...}}, {"flow": {...}}]`)
- Click **Analyze**
- Results will show anomaly flags and details

---

## 📤 Exporting Results

- Export tables as `CSV` or `JSON`
- Useful for reports and further offline analysis

---

## ⏱️ Timeline Visualization

- Choose granularity: **minute**, **hour**, or **day**
- Graph shows anomaly frequency over time
- Compare intervals between today and yesterday

---

## 🧠 Meta-Model Analysis

- Extracts aggregate behavior over time (default: 60 min)
- Features include anomaly counts and unique source IPs
- Useful for identifying "odd periods" or attack windows

---

## 🔁 Auto-Refresh

- Enabled by default (every 2 minutes)
- Can be disabled manually per tab

---

## 🚨 Escalating Multi-Anomalies

- In the **Multi-Anomaly Analysis** tab:
  - Mark anomaly events as "escalated"
  - If SMTP is configured, email alert is sent automatically

---

## 🛑 Troubleshooting

| Problem                | Solution                                                  |
|------------------------|-----------------------------------------------------------|
| `Model not found`      | Train the model first using `--retrain`                  |
| Redis connection error | Ensure Redis is running at `localhost:6379`             |
| Invalid JSON           | Check format of manually entered JSON                   |

---

## 💡 Tips & Best Practices

- Use Suricata with Redis output (`eve-log` → `redis`) in production
- Retrain models (`--retrain`) periodically to adapt to network changes
- Protect the API port (5000) using firewall or reverse proxy when exposing to public

---

---

## 📦 Integration with Suricata and daemonmove

The AI module works by analyzing data pushed to Redis. To enable this:

1. Install and configure **Suricata** on your system
2. Install and run the **daemonmove** service:
   - Reads Suricata logs
   - Converts events into structured JSON
   - Saves data to Redis for analysis

This setup is **essential** for the AI module to function.

More information: [https://suri-oculus.com/docs/log-parser-daemonmove-service/](https://suri-oculus.com/docs/log-parser-daemonmove-service/)
