#!/bin/bash

echo "[+] Installing Suri Oculus AI module..."

# Check Python
if ! command -v python3 &> /dev/null; then
    echo "[!] Python 3 not found. Please install Python 3.9+."
    exit 1
fi

# Check pip
if ! command -v pip3 &> /dev/null; then
    echo "[!] pip not found. Please install pip for Python 3."
    exit 1
fi

# Create virtual environment
if [ ! -d "venv" ]; then
    echo "[+] Creating virtual environment..."
    python3 -m venv venv
else
    echo "[+] Virtual environment already exists."
fi

# Activate environment
source venv/bin/activate

# Dependencies
echo "[+] Installing dependencies..."
pip install --upgrade pip
pip install -r requirements.txt

# Check models
MODELS=("flow_model.pkl" "http_model.pkl" "dns_model.pkl" "tls_model.pkl" "meta_model.pkl")
for MODEL in "${MODELS[@]}"; do
    if [ ! -f "$MODEL" ]; then
        echo "[!] Attention: Model $MODEL not found. You can train it manually with 'python3 main.py ... --retrain'"
    fi
done

# Check c++ library
if [ ! -f "cpplib/libsuri_features.so" ]; then
    echo "[!] Attension: File cpplib/libsuri_features.so not found (C++ lib)."
fi

echo "[✓] Installation finished. You can start with ./run.sh"
